// Zeitmessung fr den Overhead des Marshallings bei COM
// Verglichen werden identische, weitgehend leere Implementationen
// - einer Delphi-internen Klasse,
// - eines COM-Objekts (IUnknown) mit frher Bindung,
// - eines COM-Automatisierungsobjekts (IDispatch), einmal mit frher,
//   einmal mit spter Bindung.
// - desselben COM-Automatisierungsobjekts mit frher und spter Bindung,
//   aber als out-of-process-Server

unit DelphiComAutoServTestU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DelphiComServ_TLB, DelphiAutoServ_TLB, ComObj, ActiveX;

type
  TAutoEarlyCreator = function: IDelphiAutoServer of object;
  TAutoLateCreator = function: Variant of object;
  TCOverheadForm = class(TForm)
    bDelphiDirect: TButton;  // Delphi-interne Klasse
    bComEarlybind: TButton;
    bAutoLatebind: TButton;
    bAutoInEarly: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    bRegisterCOMServers: TButton;
    bAutoOutEarly: TButton;
    bAutoOutLate: TButton;
    procedure bComEarlybindClick(Sender: TObject);
    procedure bAutoInLateClick(Sender: TObject);
    procedure bAutoInEarlyClick(Sender: TObject);
    procedure bDelphiDirectClick(Sender: TObject);
    procedure bRegisterCOMServersClick(Sender: TObject);
    procedure bAutoOutEarlyClick(Sender: TObject);
    procedure bAutoOutLateClick(Sender: TObject);
  private
    procedure AutoEarlyBindBench(COMCreator: TAutoEarlyCreator; DivFac: Integer);
    function CreateAutoEarlyInProc: IDelphiAutoServer;
    function CreateAutoEarlyOutProc: IDelphiAutoServer;
    procedure AutoLateBindBench(COMCreator: TAutoLateCreator; DivFac: Integer);
    function CreateAutoLateInProc: Variant;
    function CreateAutoLateOutProc: Variant;
    procedure StartComServHost;

  end;

  // Die als COM-Objekt und Automatisierungsobjekt implementierte Klasse
  // ein drittes Mal, hier aber direkt. Die beiden anderen Klassen sind in
  // DelphiComServ und DelphiAutoServ (jeweils _TLB.pas bzw. U.pas)
  TDelphiClass = class(TObject)
  private
    IntVal: Integer;
    StrVal: WideString;
  protected
    function IntParam(Param1: Integer): HResult; stdcall;
    function NoParam: HResult; stdcall;
    function Get_IntProp(out Value: Integer): HResult; stdcall;
    function Get_StrProp(out Value: WideString): HResult; stdcall;
    function StrParam(const Param1: WideString): HResult; stdcall;
  end;



var
  COverheadForm: TCOverheadForm;

implementation
{$R *.dfm}
uses MMSystem;

const Msgs: Array[0..6] of String =
  ('Empty loop', 'NoParam', 'IntParam', 'StrParam', 'StrParam2', 'IntProp', 'StrProp');

// Implementation der Delphi-internen Klasse
function TDelphiClass.IntParam(Param1: Integer): HResult;
begin
  IntVal := Param1; Result := 0;
end;

function TDelphiClass.NoParam: HResult;
begin
  Result := 0;
end;

function TDelphiClass.Get_IntProp(out Value: Integer): HResult;
begin
  Value := IntVal; Result := 0;
end;

function TDelphiClass.Get_StrProp(out Value: WideString): HResult;
begin
  Value := StrVal; Result := 0;
end;

function TDelphiClass.StrParam(const Param1: WideString): HResult;
begin
  StrVal := Param1; Result := 0;
end;
// ---------------------------------------------

procedure TCOverheadForm.bDelphiDirectClick(Sender: TObject);
var CT: TDelphiClass;
    x, Dummy, BNum: Integer;
    SomeStr: WideString;
    STime: Cardinal;
begin
  Memo1.Lines.Add('*** Delphi-internal class ***');
  STime := timeGetTime;
  for x := 1 to 100000 do
  begin
    CT := TDelphiClass.Create;
    CT.Free;
  end;
  Memo1.Lines.Add(Format('Create (100K): %d',[timeGetTime - STime]));
  CT := TDelphiClass.Create;
  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := timeGetTime;
     for x := 1 to 1000000 do // 1E6
       case BNum of
         0: Inc(Dummy, 1);
         1: Inc(Dummy, CT.NoParam);
         2: Inc(Dummy, CT.IntParam(4));
         3: Inc(Dummy, CT.StrParam('Some string'));
         4: Inc(Dummy, CT.StrParam('Some String with twice as much characters'));
         5: Inc(Dummy, CT.Get_IntProp(Dummy));
         6: Inc(Dummy, CT.Get_StrProp(SomeStr));
       end;
     Memo1.Lines.Add(Msgs[BNum] + ': ' + IntToStr(timeGetTime-STime));
  end;
end;

procedure TCOverheadForm.bComEarlybindClick(Sender: TObject);
var CT: IDelphiComServer;
    x, Dummy, BNum: Integer;
    SomeStr: WideString;
    STime: Cardinal;
begin
  Memo1.Lines.Add('*** COM, early binding ***');
  STime := timeGetTime;
  CT := CoDelphiComServer.Create;

  Memo1.Lines.Add(Format('Create (single): %d',[timeGetTime - STime]));
  CT.Get_ProcessID(x);

  if x = GetCurrentProcessID then Memo1.Lines.Add('in-process')
   else Memo1.Lines.Add('out-of-process');

  STime := timeGetTime;
  for x := 1 to 100000 do
  begin
    CT := CoDelphiComServer.Create;
    CT := nil;
  end;
  Memo1.Lines.Add(Format('Create (100K): %d',[timeGetTime - STime]));


  CT := CoDelphiComServer.Create;
  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := timeGetTime;
     for x := 1 to 1000000 do // 1E6
       case BNum of
         0: Inc(Dummy, 1);
         1: Inc(Dummy, CT.NoParam);
         2: Inc(Dummy, CT.IntParam(4));
         3: Inc(Dummy, CT.StrParam('Some string'));
         4: Inc(Dummy, CT.StrParam('Some String with twice as much characters'));
         5: Inc(Dummy, CT.Get_IntProp(Dummy));
         6: Inc(Dummy, CT.Get_StrProp(SomeStr));
       end;

     Memo1.Lines.Add(Msgs[BNum] + ': ' + IntToStr(timeGetTime-STime));
  end;
end;

// ---------------------------------------------------------------
procedure TCOverheadForm.AutoLateBindBench(COMCreator: TAutoLateCreator;
  DivFac: Integer);
var CT: Variant;
    x, Dummy, BNum: Integer;
    SomeStr: WideString;
    STime: Cardinal;
begin
  Memo1.Lines.Add('*** AUTO, late binding ***');
  STime := timeGetTime;
  CT := COMCreator;

  Memo1.Lines.Add(Format('Create (single): %d',[timeGetTime - STime]));

  if CT.ProcessID = GetCurrentProcessID then Memo1.Lines.Add('in-process')
   else Memo1.Lines.Add('out-of-process');


  STime := timeGetTime;
  for x := 1 to 100000 div DivFac do
  begin
    CT := COMCreator;
    CT := Unassigned;
  end;
  Memo1.Lines.Add(Format('Create (100K): %d',[(timeGetTime - STime) * DivFac]));


  CT := COMCreator;
  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := timeGetTime;
     for x := 1 to 1000000 div DivFac do // 1E6
       case BNum of
         0: ;
         1: CT.NoParam;
         2: CT.IntParam(4);
         3: CT.StrParam('Some string');
         4: CT.StrParam('Some String with twice as much characters');
         5: Dummy := CT.IntProp;
         6: SomeStr := CT.StrProp;
       end;

     Memo1.Lines.Add(Msgs[BNum] + ': ' + IntToStr((timeGetTime-STime) * DivFac));
  end;
end;


function TCOverheadForm.CreateAutoLateInProc: Variant;
begin
  Result := CreateOleObject('DelphiAutoServ.DelphiAutoServer');
end;

function TCOverheadForm.CreateAutoLateOutProc: Variant;
var Unknown: IUnknown;
begin
  try
    Result := GetActiveOleObject('DelphiAutoServ.DelphiAutoServer');
  except
    try
      StartComServHost; // Start ComServHost manually
      // retry
      Result := GetActiveOleObject('DelphiAutoServ.DelphiAutoServer');
    except
      ShowMessage('Unable to start ComServHost.exe, please try manually');
      raise;
    end;
  end;
end;

procedure TCOverheadForm.bAutoOutLateClick(Sender: TObject);
begin
  AutoLateBindBench(CreateAutoLateOutProc, 300);
end;


procedure TCOverheadForm.bAutoInLateClick(Sender: TObject);
begin
  AutoLateBindBench(CreateAutoLateInProc, 10);
end;
// ---------------------------------

function TCOverheadForm.CreateAutoEarlyInProc: IDelphiAutoServer;
begin
  Result := CoDelphiAutoServer.Create;
end;

function TCOverheadForm.CreateAutoEarlyOutProc: IDelphiAutoServer;
var Unknown: IUnknown;
begin
  if (GetActiveObject(CLASS_DelphiAutoServer, nil,
    Unknown) = MK_E_UNAVAILABLE) then
  begin
    StartComServHost;
    if (GetActiveObject(CLASS_DelphiAutoServer, nil,
      Unknown) = MK_E_UNAVAILABLE)
        then raise Exception.Create('Please start Comservhost.exe manually');
  end;
  Unknown.QueryInterface(IDelphiAutoServer, Result);
end;


procedure TCOverheadForm.bAutoInEarlyClick(Sender: TObject);
begin
  AutoEarlyBindBench(CreateAutoEarlyInProc, 1);
end;

procedure TCOverheadForm.bAutoOutEarlyClick(Sender: TObject);
begin
  AutoEarlyBindBench(CreateAutoEarlyOutProc, 100);
end;


procedure TCOverheadForm.AutoEarlyBindBench(COMCreator: TAutoEarlyCreator; DivFac: Integer);
var CT: IDelphiAutoServer;
    x, Dummy, BNum: Integer;
    SomeStr: WideString;
    STime: Cardinal;
begin
  Memo1.Lines.Add('*** AUTO, early binding ***');
  STime := timeGetTime;
  CT := COMCreator; // CoDelphiAutoServer.Create;

  if CT.ProcessID = GetCurrentProcessID then Memo1.Lines.Add('in-process')
   else Memo1.Lines.Add('out-of-process');


  Memo1.Lines.Add(Format('Create (single): %d',[timeGetTime - STime]));

  STime := timeGetTime;
  for x := 1 to 100000 div DivFac do
  begin
    CT := COMCreator; // CoDelphiAutoServer.Create;
    CT := nil;
  end;
  Memo1.Lines.Add(Format('Create (100K): %d',[(timeGetTime - STime) * DivFac]));

  CT := COMCreator; // CT := CoDelphiAutoServer.Create;
  for BNum := 0 to 6 do
  begin
     Dummy := 0;
     STime := timeGetTime;
     for x := 1 to 1000000 div DivFac do // 1E6
       case BNum of
         0: ;
         1: CT.NoParam;
         2: CT.IntParam(4);
         3: CT.StrParam('Some string');
         4: CT.StrParam('Some String with twice as much characters');
         5: Dummy := CT.IntProp;
         6: SomeStr := CT.StrProp;
       end;
     Memo1.Lines.Add(Msgs[BNum] + ': ' + IntToStr((timeGetTime-STime) * DivFac));
  end;

end;


procedure TCOverheadForm.bRegisterCOMServersClick(Sender: TObject);
var x: Integer;
begin
  RegisterComServer(ExtractFilePath(ParamStr(0))+'DelphiComServ.dll');
  RegisterComServer(ExtractFilePath(ParamStr(0))+'DelphiAutoServ.dll');
  StartComServHost;
  for x := 0 to ComponentCount-1 do
    if Components[x] is TButton then TButton(Components[x]).Enabled := True;
  bRegisterCOMServers.Enabled := False;
end;

procedure TCOverheadForm.StartComServHost;
begin
   if FindWindow(nil, 'ComServHostForm - Active') = 0 then
     WinExec(PChar(ExtractFilePath(ParamStr(0))+'ComServHost.exe'), SW_NORMAL);
end;



end.
